var max_beams = 5;
var beams = new Array();

var framecounter_max = 1;
var beams_max_frames = 12;


for (i=0;i<max_beams;i++)
{
	beams[i] = new Object();
	beams[i].x = -1;
	beams[i].y = -1;
	beams[i].frame = -1;
	beams[i].framecounter = -1;
	beams[i].dir = -1;
	beams[i].damage = -1;
	beams[i].owner = 0;
	beams[i].stam = false;
}

function SpawnUpBeam(x,y, dir, owner, scale, frame, type)
{
	if (scale == undefined)
		SpawnBeam(x,y, dir, 10, owner, true);
	else
		SpawnBeam(x,y, dir, 10, owner, true, scale, frame, "wave3");
}

function SpawnBeam(x,y, dir, damage, owner, stam, scale, frame, type)
{
	if (g_current_level == 9 && stam == true)
		y-=8;


	if (frame == undefined)
		frame = 0;
	for (sb=0;sb<max_beams;sb++)
	{
		if (beams[sb].damage == -1)
		{
			break;
		}
	}
	
	if (sb<max_beams)
	{
		//create new beam
		beams[sb].damage = damage;
		beams[sb].x = x;
		beams[sb].y = y;
		beams[sb].dir = dir;
		beams[sb].frame = frame;
		beams[sb].framecounter = 0;
		beams[sb].owner = owner;
		beams[sb].stam = false;
		beams[sb].scale = 1;
		if (scale != undefined)
			beams[sb].scale = scale;
			
		SetPersonAngle("beam"+sb, 0);
		SetPersonScaleFactor("beam"+sb, 1,1);
		if (scale != undefined)
			SetPersonScaleFactor("beam"+sb, scale,scale);
		SetPersonIDDirection(beams[sb].id1, "wave1");
		SetPersonIDLayer(beams[sb].id1, g_supernaut_head_layer+1);
	}
	if (stam == true)
	{
	
		beams[sb].stam = true;
		SetPersonAngle("beam"+sb, -Math.PI/2);
		SetPersonScaleFactor("beam"+sb, 1,1);
		if (scale != undefined)
			SetPersonScaleFactor("beam"+sb, scale,scale);
		if (type == "wave3")
			SetPersonIDDirection(beams[sb].id1, "wave3");
		else
			SetPersonIDDirection(beams[sb].id1, "wave2");
	}
}

function ClearBeams()
{
	for (sb=0;sb<max_beams;sb++)
	{
		beams[sb].frame = beams_max_frames+1;
		beams[sb].damage = -1;
		beams[sb].x = -100;
		beams[sb].y = -100;	

		SetPersonIDX(beams[sb].id1, beams[sb].x+24);
		SetPersonIDY(beams[sb].id1, beams[sb].y);
		SetPersonIDFrame(beams[sb].id1, beams[sb].frame);
		SetPersonIDFrame(beams[sb].id1, beams[sb].frame);
		SetPersonIDHorizontalFlip(beams[sb].id1, (-1*beams[sb].dir+1)/2);
	}


}


function UpdateBeams()
{
	var scale = 1;
	for (sb=0;sb<max_beams;sb++)
	{
		scale = beams[sb].scale;
		if (beams[sb].damage > -1)
		{
			if (g_frames % frameupdate == 0)
			  beams[sb].framecounter++;
			if (beams[sb].framecounter == framecounter_max)
			{
				beams[sb].framecounter = 0;
				beams[sb].frame++;
				if (beams[sb].owner != 0)
				{
					if (beams[sb].stam == true)
					{
						if (beams[sb].frame == 2)
						{
							//do damage
	//						entities[0].x-160-16,entities[0].y-160+32
							
							if (Math.abs(entities[0].x - beams[sb].x-160-16) < 24)
							{
								if (beams[sb].dir == 1)
								{
									if (entities[0].y - beams[sb].y-160+32 < 320 && entities[0].y-beams[sb].y-160+32> -16)
									{
										SpriteAttack(beams[sb].owner, true, beams[sb].damage, true, true);
									}
								}
								else if (beams[sb].dir == -1)
								{
									if (beams[sb].y+160-32 - entities[0].y  < 320 && beams[sb].y+160-32-entities[0].y > -16)
									{
										SpriteAttack(beams[sb].owner, true, beams[sb].damage, true, true);
									}
								}
							}
						}
					}
					else
					{
						if (beams[sb].frame == 7)
						{
							//do damage
							if (Math.abs(entities[0].y - beams[sb].y) < 24*scale)
							{
								if (beams[sb].dir == 1)
								{
									if (entities[0].x - beams[sb].x < 320 && entities[0].x-beams[sb].x > 0)
									{
										SpriteAttack(beams[sb].owner, true, beams[sb].damage);
									}
								}
								else if (beams[sb].dir == -1)
								{
									if (beams[sb].x - entities[0].x  < 320 && beams[sb].x-entities[0].x > 0)
									{
										SpriteAttack(beams[sb].owner, true, beams[sb].damage);
									}
								}
							}
						}
					}
				}
				else
				{
					for (bbi=0;bbi<max_entities;bbi++)
					{
						if (entities[bbi].type > 0 && entities[bbi].active == true&& entities[bbi].stop == false && entities[bbi].ambush == false)
						{
							if (beams[sb].frame == 7)
							{
									//do damage
								if (Math.abs(entities[bbi].y - beams[sb].y) < 24*scale)
								{
									if (beams[sb].dir == 1)
									{
										if (entities[bbi].x - beams[sb].x < 320 && entities[bbi].x-beams[sb].x > 0)
										{
											DoWaveEnemyDamage(bbi, beams[sb].owner, beams[sb].damage);
										}
									}
									else if (beams[sb].dir == -1)
									{
										if (beams[sb].x - entities[bbi].x  < 320 && beams[sb].x-entities[bbi].x > 0)
										{
											DoWaveEnemyDamage(bbi, beams[sb].owner, beams[sb].damage);
										}
									}
								}
							}				
						}
					}
				
					if (g_supernaut_active == 2 && beams[sb].frame == 7)
					{
						for (bbi = 0;bbi<20;bbi++)
						{
							if (DoSwingAttack(beams[sb].x+beams[sb].dir*16*bbi-beams[sb].dir*34,beams[sb].y,beams[sb].dir,beams[sb].damage, 0, true))
								break;
						}
					}
					if (g_boss_active > 0 && beams[sb].frame == 7)
					{
						if (Math.abs(beams[sb].y-boss.hy) < 32)
						{
//							FlipScreen();
							if (beams[sb].dir == 1)
							{
								if (boss.hx - beams[sb].x < 320 && boss.hx-beams[sb].x > 0)
								{
									DoBossHp1Damage(beams[sb].damage)
								}
							}
							else if (beams[sb].dir == -1)
							{
								if (beams[sb].x - boss.hx  < 320 && beams[sb].x-boss.hx > 0)
								{
									DoBossHp1Damage(beams[sb].damage)
								}
							}
						}
						for (k=0;k<max_boss_colours;k++)
						{
							if (Math.abs(boss.y+bcolours[k].cy-beams[sb].y) < 8 && bcolours[k].hp > 0 && boss.scream <= 0)
							{
								if (beams[sb].dir == 1)
								{
									if (boss.x+bcolours[k].cx - beams[sb].x < 320 && boss.x+bcolours[k].cx-beams[sb].x > 0)
									{
										MakeBossBleed(k, beams[sb].damage);
									}
								}
								else if (beams[sb].dir == -1)
								{
									if (-boss.x-bcolours[k].cx + beams[sb].x < 320 && -boss.x-bcolours[k].cx+beams[sb].x > 0)
									{
										MakeBossBleed(k, beams[sb].damage);
									}
								}	
							}
						}
					}
				}
				if (beams[sb].frame > beams_max_frames)
				{
					beams[sb].damage = -1;
					beams[sb].x = -100;
					beams[sb].y = -100;
				}
			
			}

			//...
		}
		if (beams[sb].dir == -1)
			SetPersonIDX(beams[sb].id1, beams[sb].x-320+8);
		else
			SetPersonIDX(beams[sb].id1, beams[sb].x+24);
		SetPersonIDY(beams[sb].id1, beams[sb].y);
		SetPersonIDFrame(beams[sb].id1, beams[sb].frame);
		SetPersonIDFrame(beams[sb].id1, beams[sb].frame);
		SetPersonIDHorizontalFlip(beams[sb].id1, (-1*beams[sb].dir+1)/2);
	}
}
